/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.region;

import filenet.vw.api.VWException;
import filenet.vw.api.VWStepProcessorInfoDefinition;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import java.awt.ComponentOrientation;
import java.awt.Frame;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

public class VWConfigStepProcessorInfoTableModel
extends AbstractTableModel {
    public static final int COLUMN_COUNT = 7;
    public static final int COLUMN_TYPE = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_LANGUAGE = 2;
    public static final int COLUMN_LOCATION = 3;
    public static final int COLUMN_WIDTH = 4;
    public static final int COLUMN_HEIGHT = 5;
    public static final int COLUMN_CLASS = 6;
    private static final int STATUS_NONE = 0;
    private static final int STATUS_NEW = 1;
    private static final int STATUS_MODIFIED = 2;
    private Vector m_spidList = null;
    private Vector m_deletedSpidList = null;
    private Vector m_allowModifyList = null;
    private VWSystemConfiguration m_sysConfig = null;
    private boolean m_bHasChanged = false;
    private String m_title = null;
    private VWStepProcessorInfoDefinition[] m_rowData = null;
    private Frame m_parentFrame = null;

    public VWConfigStepProcessorInfoTableModel(VWSystemConfiguration sysConfig, Frame parentFrame) {
        this.m_parentFrame = parentFrame;
        this.init(sysConfig);
    }

    public DefaultCellEditor getTypeCellEditor() {
        DefaultCellEditor cellEditor = null;
        try {
            JComboBox<Object> jbx = new JComboBox<Object>();
            jbx.setRenderer(new VWLabelListCellRenderer());
            ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
            jbx.applyComponentOrientation(compOrientation);
            jbx.addItem(VWResource.DefaultLaunch);
            jbx.addItem(VWResource.DefaultStep);
            jbx.addItem(VWResource.Launch);
            jbx.addItem(VWResource.Step);
            cellEditor = new DefaultCellEditor(jbx);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return cellEditor;
    }

    public DefaultCellEditor getLanguageCellEditor() {
        DefaultCellEditor cellEditor = null;
        try {
            JComboBox<Object> jbx = new JComboBox<Object>();
            jbx.setRenderer(new VWLabelListCellRenderer());
            ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
            jbx.applyComponentOrientation(compOrientation);
            jbx.addItem(VWResource.Java);
            jbx.addItem(VWResource.HTML);
            cellEditor = new DefaultCellEditor(jbx);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return cellEditor;
    }

    public void addRow() {
        try {
            if (this.m_spidList == null) {
                this.m_spidList = new Vector();
            }
            VWStepProcessorInfoDefinition aSPDef = new VWStepProcessorInfoDefinition();
            ConfigStepProcessInfo stepInfo = new ConfigStepProcessInfo(aSPDef, 1, true);
            this.m_spidList.addElement(stepInfo);
            int nRow = this.m_spidList.size() - 1;
            this.fireTableRowsInserted(nRow, nRow);
            this.m_bHasChanged = true;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean canDeleteRow(int nRow) {
        if (this.m_spidList == null || this.m_spidList.size() < nRow + 1) {
            return false;
        }
        ConfigStepProcessInfo stepInfo = (ConfigStepProcessInfo)this.m_spidList.elementAt(nRow);
        if (stepInfo != null) {
            return stepInfo.canDelete();
        }
        return false;
    }

    public void removeRow(int nRow) {
        try {
            if (this.m_spidList == null || this.m_spidList.size() < nRow + 1) {
                return;
            }
            ConfigStepProcessInfo stepInfo = (ConfigStepProcessInfo)this.m_spidList.elementAt(nRow);
            if (stepInfo.m_nStatus != 1) {
                if (this.m_deletedSpidList == null) {
                    this.m_deletedSpidList = new Vector();
                }
                this.m_deletedSpidList.addElement(stepInfo);
            }
            this.m_spidList.removeElementAt(nRow);
            this.fireTableRowsDeleted(nRow, nRow);
            this.m_bHasChanged = true;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean hasChanged() {
        return this.m_bHasChanged;
    }

    public boolean update() {
        try {
            VWStepProcessorInfoDefinition aSPDef;
            ConfigStepProcessInfo stepInfo;
            int i;
            int rowCount = this.m_spidList.size();
            for (i = 0; i < rowCount; ++i) {
                try {
                    stepInfo = (ConfigStepProcessInfo)this.m_spidList.elementAt(i);
                    if ((stepInfo.m_nStatus & 1) == 1) {
                        aSPDef = stepInfo.m_stepInfoDef;
                        VWStepProcessorInfoDefinition newSPDef = this.m_sysConfig.createStepProcessorInfoDefinition();
                        newSPDef.setName(aSPDef.getName());
                        String appName = aSPDef.getApplicationName();
                        if (appName != null) {
                            newSPDef.setApplicationName(appName);
                        }
                        newSPDef.setHasChanged(aSPDef.hasChanged());
                        newSPDef.setHeight(aSPDef.getHeight());
                        newSPDef.setWidth(aSPDef.getWidth());
                        newSPDef.setLocations(aSPDef.getLocations());
                        newSPDef.setProcessorType(aSPDef.getProcessorType());
                        newSPDef.setAppType(aSPDef.getAppType());
                        continue;
                    }
                    if ((stepInfo.m_nStatus & 2) != 2) continue;
                    aSPDef = stepInfo.m_stepInfoDef;
                    this.m_rowData[i].getCopy(aSPDef);
                    continue;
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    JOptionPane.showMessageDialog(null, VWResource.SPDefProcessError.toString(String.valueOf(i + 1), ex.getLocalizedMessage()), VWResource.ErrorMessage, 0);
                    return false;
                }
            }
            if (this.m_deletedSpidList != null) {
                rowCount = this.m_deletedSpidList.size();
                for (i = 0; i < rowCount; ++i) {
                    try {
                        stepInfo = (ConfigStepProcessInfo)this.m_deletedSpidList.elementAt(i);
                        if ((stepInfo.m_nStatus & 1) == 1) continue;
                        aSPDef = stepInfo.m_stepInfoDef;
                        this.m_sysConfig.deleteStepProcessorInfoDefinition(aSPDef);
                        continue;
                    }
                    catch (Exception ex) {
                        VWDebug.logException(ex);
                        JOptionPane.showMessageDialog(null, VWResource.SPDefProcessError.toString(String.valueOf(i + 1), ex.getLocalizedMessage()), VWResource.ErrorMessage, 0);
                        return false;
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return false;
        }
        return true;
    }

    public boolean verifyStepProcessorInfoDefinitons() {
        boolean bSuccess = true;
        try {
            int rowCount = this.m_spidList.size();
            boolean bHasDefaultLauncher = false;
            boolean bHasDefaultStep = false;
            for (int i = 0; i < rowCount; ++i) {
                ConfigStepProcessInfo stepInfo = (ConfigStepProcessInfo)this.m_spidList.elementAt(i);
                VWStepProcessorInfoDefinition aSPDef = stepInfo.m_stepInfoDef;
                String name = aSPDef.getName();
                if (name == null || name.length() < 1) {
                    JOptionPane.showMessageDialog(null, VWResource.MissingSPDName.toString(String.valueOf(i + 1)), VWResource.ErrorMessage, 0);
                    return false;
                }
                Hashtable locations = aSPDef.getLocations();
                if (locations == null || locations.isEmpty()) {
                    JOptionPane.showMessageDialog(null, VWResource.MissingSPDLocation.toString(String.valueOf(i + 1)), VWResource.ErrorMessage, 0);
                    return false;
                }
                int processorType = aSPDef.getProcessorType();
                if (processorType == 1) {
                    if (bHasDefaultLauncher) {
                        JOptionPane.showMessageDialog(null, VWResource.MultipleDefaultLauncherType.toString(String.valueOf(i + 1)), VWResource.ErrorMessage, 0);
                        return false;
                    }
                    bHasDefaultLauncher = true;
                } else if (processorType == 2) {
                    if (bHasDefaultStep) {
                        JOptionPane.showMessageDialog(null, VWResource.MultipleDefaultStepType.toString(String.valueOf(i + 1)), VWResource.ErrorMessage, 0);
                        return false;
                    }
                    bHasDefaultStep = true;
                } else if (processorType != 8 && processorType != 4) {
                    JOptionPane.showMessageDialog(null, VWResource.InvalidSPDType.toString(String.valueOf(i + 1)), VWResource.ErrorMessage, 0);
                    return false;
                }
                int languageType = aSPDef.getAppType();
                if (languageType == 64) {
                    if (aSPDef.getApplicationName() == null) {
                        JOptionPane.showMessageDialog(null, VWResource.MissingSPDClass.toString(String.valueOf(i + 1)), VWResource.ErrorMessage, 0);
                        return false;
                    }
                } else if (languageType != 32) {
                    JOptionPane.showMessageDialog(null, VWResource.InvalidSPDLanguage.toString(String.valueOf(i + 1)), VWResource.ErrorMessage, 0);
                    return false;
                }
                if (aSPDef.getWidth() >= 1 && aSPDef.getHeight() >= 1) continue;
                JOptionPane.showMessageDialog(null, VWResource.InvalidDimension.toString(String.valueOf(i + 1)), VWResource.ErrorMessage, 0);
                return false;
            }
            if (this.m_sysConfig.getIsRetrievedFromServer()) {
                if (!bHasDefaultLauncher) {
                    JOptionPane.showMessageDialog(null, VWResource.MissingDefaultLauncher, VWResource.ErrorMessage, 0);
                    return false;
                }
                if (!bHasDefaultStep) {
                    JOptionPane.showMessageDialog(null, VWResource.MissingDefaultStep, VWResource.ErrorMessage, 0);
                    return false;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return false;
        }
        return true;
    }

    public void releaseResources() {
        if (this.m_spidList != null) {
            this.m_spidList.removeAllElements();
            this.m_spidList = null;
        }
        if (this.m_deletedSpidList != null) {
            this.m_deletedSpidList.removeAllElements();
            this.m_deletedSpidList = null;
        }
        this.m_sysConfig = null;
        this.m_title = null;
        if (this.m_rowData != null) {
            for (int i = 0; i < this.m_rowData.length; ++i) {
                this.m_rowData[i] = null;
            }
            this.m_rowData = null;
        }
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: 
            case 1: 
            case 2: {
                return String.class;
            }
            case 3: {
                return Hashtable.class;
            }
            case 4: 
            case 5: 
            case 6: {
                return String.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 7;
    }

    public String getColumnName(int nColumn) {
        switch (nColumn) {
            case 0: {
                return VWResource.Type;
            }
            case 1: {
                return VWResource.Name;
            }
            case 2: {
                return VWResource.Language;
            }
            case 3: {
                return VWResource.Location;
            }
            case 4: {
                return VWResource.Width;
            }
            case 5: {
                return VWResource.Height;
            }
            case 6: {
                return VWResource.ClassName;
            }
        }
        return null;
    }

    public int getRowCount() {
        if (this.m_spidList != null) {
            return this.m_spidList.size();
        }
        return 0;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            if (this.m_spidList == null) {
                return null;
            }
            ConfigStepProcessInfo stepInfo = (ConfigStepProcessInfo)this.m_spidList.elementAt(rowIndex);
            if (stepInfo == null) {
                return null;
            }
            VWStepProcessorInfoDefinition stepInfoDef = stepInfo.m_stepInfoDef;
            if (stepInfoDef == null) {
                return null;
            }
            switch (columnIndex) {
                case 0: {
                    return this.getStringFromType(stepInfoDef.getProcessorType());
                }
                case 1: {
                    return stepInfo.m_stepInfoDef.getName();
                }
                case 2: {
                    return this.getStringFromLanguage(stepInfoDef.getAppType());
                }
                case 3: {
                    return stepInfoDef.getLocations();
                }
                case 4: {
                    return Integer.toString(stepInfoDef.getWidth());
                }
                case 5: {
                    return Integer.toString(stepInfoDef.getHeight());
                }
                case 6: {
                    return stepInfoDef.getApplicationName();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        ConfigStepProcessInfo stepInfo = (ConfigStepProcessInfo)this.m_spidList.elementAt(nRowIndex);
        if (stepInfo == null) {
            return false;
        }
        switch (nColumnIndex) {
            case 1: {
                return stepInfo.canModify();
            }
        }
        return true;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        String strValue = null;
        if (this.m_spidList == null) {
            return;
        }
        try {
            VWStepProcessorInfoDefinition stepInfoDef;
            ConfigStepProcessInfo stepInfo = (ConfigStepProcessInfo)this.m_spidList.elementAt(rowIndex);
            if (stepInfo == null) {
                return;
            }
            if (!stepInfo.canModify()) {
                if (VWMessageDialog.showConfirmDialog(this.m_parentFrame, VWResource.ModifyStepProcessorWarning.toString(stepInfo.getName()), VWResource.s_warning, 3) != 1) {
                    return;
                }
                stepInfo.setCanModify(true);
            }
            if ((stepInfoDef = stepInfo.m_stepInfoDef) == null) {
                return;
            }
            if (aValue instanceof String) {
                strValue = ((String)aValue).trim();
            }
            switch (columnIndex) {
                case 0: {
                    int nType = this.getTypeFromString(strValue);
                    if (nType == -1) break;
                    stepInfoDef.setProcessorType(nType);
                    stepInfoDef.setHasChanged(true);
                    stepInfo.m_nStatus |= 2;
                    this.m_bHasChanged = true;
                    break;
                }
                case 1: {
                    stepInfoDef.setName(strValue);
                    stepInfoDef.setHasChanged(true);
                    stepInfo.m_nStatus |= 2;
                    this.m_bHasChanged = true;
                    break;
                }
                case 2: {
                    int nLanguage = this.getLanguageFromString(strValue);
                    if (nLanguage == -1) break;
                    stepInfoDef.setAppType(nLanguage);
                    stepInfoDef.setHasChanged(true);
                    stepInfo.m_nStatus |= 2;
                    this.m_bHasChanged = true;
                    break;
                }
                case 3: {
                    stepInfoDef.setLocations((Hashtable)aValue);
                    stepInfoDef.setHasChanged(true);
                    stepInfo.m_nStatus |= 2;
                    this.m_bHasChanged = true;
                    break;
                }
                case 4: {
                    int iWidth = Integer.parseInt(strValue);
                    stepInfoDef.setWidth(iWidth);
                    stepInfoDef.setHasChanged(true);
                    stepInfo.m_nStatus |= 2;
                    this.m_bHasChanged = true;
                    break;
                }
                case 5: {
                    int iHeight = Integer.parseInt(strValue);
                    stepInfoDef.setHeight(iHeight);
                    stepInfoDef.setHasChanged(true);
                    stepInfo.m_nStatus |= 2;
                    this.m_bHasChanged = true;
                    break;
                }
                case 6: {
                    stepInfoDef.setApplicationName(strValue);
                    stepInfoDef.setHasChanged(true);
                    stepInfo.m_nStatus |= 2;
                    this.m_bHasChanged = true;
                }
            }
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.InvalidNumberFormat.toString(strValue, String.valueOf(rowIndex + 1)), this.m_title, 2);
        }
        catch (VWException ex) {
            JOptionPane.showMessageDialog(this.m_parentFrame, ex.getLocalizedMessage(), this.m_title, 0);
            VWDebug.logException(ex);
        }
    }

    private void init(VWSystemConfiguration sysConfig) {
        try {
            this.m_sysConfig = sysConfig;
            this.m_spidList = new Vector();
            this.m_title = VWIDMBaseFactory.instance().getVWString(4).toString();
            this.m_rowData = sysConfig.getStepProcessorInfoDefinitions();
            if (this.m_rowData == null) {
                return;
            }
            for (int nIndex = 0; nIndex < this.m_rowData.length; ++nIndex) {
                VWStepProcessorInfoDefinition aSPID = new VWStepProcessorInfoDefinition();
                aSPID.getCopy(this.m_rowData[nIndex]);
                aSPID.setHasChanged(false);
                ConfigStepProcessInfo stepInfo = new ConfigStepProcessInfo(aSPID, 0, false);
                this.m_spidList.addElement(stepInfo);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private String getStringFromType(int nType) {
        if (nType == 1) {
            return VWResource.DefaultLaunch;
        }
        if (nType == 2) {
            return VWResource.DefaultStep;
        }
        if (nType == 4) {
            return VWResource.Launch;
        }
        if (nType == 8) {
            return VWResource.Step;
        }
        return null;
    }

    private int getTypeFromString(String type) {
        if (VWStringUtils.compare(type, VWResource.DefaultLaunch) == 0) {
            return 1;
        }
        if (VWStringUtils.compare(type, VWResource.DefaultStep) == 0) {
            return 2;
        }
        if (VWStringUtils.compare(type, VWResource.Launch) == 0) {
            return 4;
        }
        if (VWStringUtils.compare(type, VWResource.Step) == 0) {
            return 8;
        }
        return -1;
    }

    private String getStringFromLanguage(int nType) {
        if (nType == 32) {
            return VWResource.HTML;
        }
        if (nType == 64) {
            return VWResource.Java;
        }
        return null;
    }

    private int getLanguageFromString(String lang) {
        if (VWStringUtils.compare(lang, VWResource.HTML) == 0) {
            return 32;
        }
        if (VWStringUtils.compare(lang, VWResource.Java) == 0) {
            return 64;
        }
        return -1;
    }

    private class ConfigStepProcessInfo {
        public VWStepProcessorInfoDefinition m_stepInfoDef = null;
        public int m_nStatus = 0;
        public boolean m_bCanModify = false;

        ConfigStepProcessInfo(VWStepProcessorInfoDefinition stepInfoDef, int nStatus, boolean bCanModify) {
            this.m_stepInfoDef = stepInfoDef;
            this.m_nStatus = nStatus;
            this.m_bCanModify = bCanModify;
        }

        public String getName() {
            return this.m_stepInfoDef.getName();
        }

        public boolean canDelete() {
            if (this.m_stepInfoDef != null) {
                return this.m_stepInfoDef.getId() == -1;
            }
            return false;
        }

        public boolean canModify() {
            if (this.canDelete()) {
                return true;
            }
            return this.m_bCanModify;
        }

        public void setCanModify(boolean bCanModify) {
            this.m_bCanModify = bCanModify;
        }
    }
}

